/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Objects;
import me.fixfis.Entities.Auth;
import me.fixfis.Entities.ServerStuff;
import me.fixfis.stuff.FPluginManagerCommands;
import me.fixfis.stuff.LocalLogger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.java.JavaPlugin;

public class InitServer {
    public static String URL_BASE = "https://server.fixfis.online/fplugin/";
    private final int idPlugin;
    private final String ipServer;
    private final JavaPlugin plugin;
    private final String mainCommand;
    private final Auth auth;
    private final ServerStuff serverStuff;
    private boolean estadoDeLicencia;

    public InitServer(int idPlugin, JavaPlugin plugin, String mainCommand) {
        this.idPlugin = idPlugin;
        this.ipServer = this.getPublicIp();
        this.plugin = plugin;
        this.mainCommand = mainCommand;
        this.auth = new Auth();
        this.serverStuff = new ServerStuff();
        this.validarDatos();
    }

    void validarDatos() {
        int response = this.auth.getAuth(this.ipServer, this.idPlugin).getInt("v");
        switch (response) {
            case 0: {
                LocalLogger.loggerAd("El Plugin est\u00e1 en cole de aprobaci\u00f3n, \u00bfEsta aprobado?, reinicie el server.");
                this.estadoDeLicencia = false;
                break;
            }
            case 1: {
                LocalLogger.loggerAd("El Plugin esta activado.");
                this.serverStuff.addPowerOn(this.ipServer, this.idPlugin);
                this.estadoDeLicencia = true;
                break;
            }
            case 10: {
                LocalLogger.loggerAd("Falta enviar Autentificacion de uso.");
                Objects.requireNonNull(this.plugin.getCommand(this.mainCommand)).setExecutor((CommandExecutor)new FPluginManagerCommands(this));
                this.estadoDeLicencia = false;
            }
        }
    }

    private String getPublicIp() {
        try {
            URL url = new URL("https://api.ipify.org");
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            return in.readLine() + ":" + Bukkit.getServer().getPort();
        }
        catch (Exception e) {
            return "NO_SE_PUDO_OBTENER_IP";
        }
    }

    public String toString() {
        return "InitServer{idPlugin=" + this.idPlugin + ", ipServer='" + this.ipServer + "', plugin=" + String.valueOf(this.plugin) + ", mainCommand='" + this.mainCommand + "', auth=" + String.valueOf(this.auth) + ", serverStuff=" + String.valueOf(this.serverStuff) + ", estadoDeLicencia=" + this.estadoDeLicencia + "}";
    }

    public Auth getAuth() {
        return this.auth;
    }

    public boolean getEstadoDeLicencia() {
        return this.estadoDeLicencia;
    }

    public ServerStuff getServerStuff() {
        return this.serverStuff;
    }

    public String getIpServer() {
        return this.ipServer;
    }

    public int getIdPlugin() {
        return this.idPlugin;
    }
}

