/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis;

import java.util.Objects;
import me.fixfis.Entities.Auth;
import me.fixfis.Entities.ServerStuff;
import me.fixfis.stuff.FPluginManagerCommands;
import me.fixfis.stuff.LocalLogger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.java.JavaPlugin;

public class InitServer {
    public static String URL_BASE = "https://server.fixfis.online/fplugin/";
    private final int idPlugin;
    private final String ipServer;
    private final JavaPlugin plugin;
    private final String mainCommand;
    private final Auth auth;
    private final ServerStuff serverStuff;
    private boolean estadoDeLicencia;

    public InitServer(int idPlugin, String ipServer, JavaPlugin plugin, String mainCommand) {
        this.idPlugin = idPlugin;
        this.ipServer = ipServer;
        this.plugin = plugin;
        this.mainCommand = mainCommand;
        this.auth = new Auth();
        this.serverStuff = new ServerStuff();
        this.validarDatos();
    }

    void validarDatos() {
        int response = this.auth.getAuth(this.ipServer, this.idPlugin).getInt("v");
        switch (response) {
            case 0: {
                LocalLogger.logger("El Plugin est\u00e1 en cole de aprobaci\u00f3n, \u00bfEsta aprobado?, reinicie el server.");
                this.estadoDeLicencia = false;
                break;
            }
            case 1: {
                LocalLogger.logger("El Plugin esta activado.");
                this.serverStuff.addPowerOn(this.ipServer, this.idPlugin);
                this.estadoDeLicencia = true;
                break;
            }
            case 10: {
                LocalLogger.logger("Falta enviar Autentificacion de uso.");
                Objects.requireNonNull(this.plugin.getCommand(this.mainCommand)).setExecutor((CommandExecutor)new FPluginManagerCommands(this));
                this.estadoDeLicencia = false;
            }
        }
    }

    public Auth getAuth() {
        return this.auth;
    }

    public boolean getEstadoDeLicencia() {
        return this.estadoDeLicencia;
    }

    public ServerStuff getServerStuff() {
        return this.serverStuff;
    }

    public String getIpServer() {
        return this.ipServer;
    }

    public int getIdPlugin() {
        return this.idPlugin;
    }
}

