/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.minijuegos;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.items.SUHItems;
import me.fixfis.sUHCore.minijuegos.MiniJuegoBase;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FEntity;
import me.fixfis.sUHCore.utils.OffTopic;
import me.fixfis.sUHCore.utils.logger.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Shulker;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class HideAndSeek
extends MiniJuegoBase {
    private final Set<Door> doors = new HashSet<Door>();
    private final Set<UUID> hunters = new HashSet<UUID>();
    private final Set<UUID> runners = new HashSet<UUID>();
    final Set<Player> players = new HashSet<Player>();
    private final HashMap<UUID, Integer> runningTasks = new HashMap();
    private final int intervalTicks = 5;
    private final Set<UUID> clickedEntityes = new HashSet<UUID>();
    Set<UUID> cooldownPlayer = new HashSet<UUID>();

    public HideAndSeek(World world, String keyName) {
        super(world, keyName);
        if (this.jsonMinigame.has("doors")) {
            JSONArray doors = this.jsonMinigame.getJSONArray("doors");
            for (int i = 0; i < doors.length(); ++i) {
                JSONObject door = doors.getJSONObject(i);
                JSONObject collision = door.getJSONObject("collision");
                Door doorObject = new Door(UUID.fromString(door.getString("axis")), new Collision(UUID.fromString(collision.getString("a")), UUID.fromString(collision.getString("s"))), Symbol.valueOf(door.getString("symbol")), door.getInt("yaw"), door.getBoolean("locked"), door.getBoolean("opened"));
                this.doors.add(doorObject);
            }
            FLogger.debugging("door cargadas hs:" + this.doors.size());
        }
    }

    @Override
    protected void comando(@NotNull Player p, @NotNull String[] s) {
        switch (s[0]) {
            case "summonDoor": {
                if (s.length < 2) break;
                this.summnoDoor(p, s[1]);
                break;
            }
            case "bloquearTodo": {
                this.bloquearTodasLasPuertas(p.getWorld());
                break;
            }
            case "grupos": {
                this.gruposFormar(s);
                break;
            }
            case "clearGrupoV": {
                OffTopic.removeGlow("red");
                OffTopic.removeGlow("blue");
                break;
            }
            case "clearGrupoF": {
                this.hunters.clear();
                this.runners.clear();
            }
        }
    }

    void gruposFormar(String[] s) {
        block4: {
            String color;
            block3: {
                this.players.clear();
                color = s[1];
                for (int i = 2; i < s.length; ++i) {
                    Player player = Bukkit.getPlayer((String)s[i]);
                    if (player == null) continue;
                    this.players.add(player);
                }
                if (!color.equals("red")) break block3;
                for (Player p : this.players) {
                    this.hunters.add(p.getUniqueId());
                    OffTopic.applyGlow(p, ChatColor.RED, "red");
                }
                break block4;
            }
            if (!color.equals("blue")) break block4;
            for (Player p : this.players) {
                this.runners.add(p.getUniqueId());
                OffTopic.applyGlow(p, ChatColor.BLUE, "blue");
            }
        }
    }

    @EventHandler
    public void onSprint(PlayerToggleSprintEvent event) {
        Player player = event.getPlayer();
        if (event.isSprinting()) {
            this.startRunningSound(player);
        } else {
            this.stopRunningSound(player);
        }
    }

    private void startRunningSound(final Player player) {
        int limit;
        String team;
        UUID uuid = player.getUniqueId();
        if (this.runningTasks.containsKey(uuid)) {
            return;
        }
        if (this.hunters.contains(uuid)) {
            team = "hunter";
            limit = 5;
        } else if (this.runners.contains(player.getUniqueId())) {
            team = "runners";
            limit = 10;
        } else {
            limit = 0;
            team = null;
        }
        if (team == null || limit == 0) {
            return;
        }
        int taskId = new BukkitRunnable(){

            public void run() {
                if (!player.isOnline() || !player.isSprinting()) {
                    HideAndSeek.this.stopRunningSound(player);
                    this.cancel();
                    return;
                }
                int i = SUHCore.random.nextInt(1, limit);
                if (!player.isFlying() && player.isOnGround()) {
                    Bukkit.getOnlinePlayers().forEach(p -> p.playSound(player.getLocation(), "entity." + team + "." + i, SoundCategory.PLAYERS, 1.0f, 1.0f));
                }
            }
        }.runTaskTimer((Plugin)SUHCore.instance, 0L, 5L).getTaskId();
        this.runningTasks.put(uuid, taskId);
    }

    private void stopRunningSound(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.runningTasks.containsKey(uuid)) {
            Bukkit.getScheduler().cancelTask(this.runningTasks.get(uuid).intValue());
            this.runningTasks.remove(uuid);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEntityEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getRightClicked().getScoreboardTags().contains("door")) {
            Entity entity = e.getRightClicked();
            FLogger.info("pasa" + entity.getName());
            this.openNaNoor(e.getRightClicked(), e.getPlayer(), true);
        }
    }

    void bloquearTodasLasPuertas(World world) {
        for (Door door : this.doors) {
            double[] dArray;
            ArmorStand axis = (ArmorStand)world.getEntity(door.axis);
            ArmorStand carry = (ArmorStand)world.getEntity(door.collision.stand);
            Shulker colShulker = (Shulker)world.getEntity(door.collision.shulker);
            if (axis == null || carry == null || colShulker == null) {
                if (axis != null) {
                    axis.remove();
                }
                if (carry != null) {
                    carry.remove();
                }
                if (colShulker != null) {
                    colShulker.remove();
                }
                this.doors.remove(door);
                FLogger.warning("puerta corrupta eliminada en");
                continue;
            }
            if (door.locked) continue;
            Location axisLoc = axis.getLocation().clone();
            axisLoc.setYaw((float)door.yaw.intValue());
            axis.teleport(axisLoc);
            carry.removePassenger((Entity)colShulker);
            switch (door.yaw) {
                case 0: {
                    double[] dArray2 = new double[2];
                    dArray2[0] = -0.5;
                    dArray = dArray2;
                    dArray2[1] = 0.0;
                    break;
                }
                case 90: {
                    double[] dArray3 = new double[2];
                    dArray3[0] = 0.0;
                    dArray = dArray3;
                    dArray3[1] = -0.5;
                    break;
                }
                case 180: {
                    double[] dArray4 = new double[2];
                    dArray4[0] = 0.5;
                    dArray = dArray4;
                    dArray4[1] = 0.0;
                    break;
                }
                case -90: {
                    double[] dArray5 = new double[2];
                    dArray5[0] = 0.0;
                    dArray = dArray5;
                    dArray5[1] = 0.5;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + door.yaw);
                }
            }
            double[] doorlocation = dArray;
            carry.teleport(axis.getLocation().clone().add(doorlocation[0] * -1.0, -0.4, doorlocation[1] * -1.0));
            door.locked = true;
            door.opened = false;
        }
    }

    void removeDoor(Door door, World world) {
        this.doors.remove(door);
        world.getEntity(door.axis).remove();
        world.getEntity(door.collision.stand).remove();
        world.getEntity(door.collision.shulker).remove();
    }

    private boolean cooldown(final Player player) {
        if (this.cooldownPlayer.contains(player.getUniqueId())) {
            return true;
        }
        this.cooldownPlayer.add(player.getUniqueId());
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                HideAndSeek.this.cooldownPlayer.remove(player.getUniqueId());
            }
        };
        task.runTaskLater((Plugin)SUHCore.instance, 100L);
        return false;
    }

    void openNaNoor(final Entity entity, final Player p, final boolean bol) {
        double[] dArray;
        if (this.clickedEntityes.contains(entity.getUniqueId())) {
            return;
        }
        Door door = null;
        for (Door d : this.doors) {
            if (!d.collision.stand.equals(entity.getUniqueId()) && !d.collision.shulker.equals(entity.getUniqueId())) continue;
            door = d;
            FLogger.info("puertaencontrada");
            break;
        }
        if (door == null) {
            return;
        }
        ItemStack hand = p.getInventory().getItemInMainHand();
        if (hand.getType() == Material.TARGET && p.hasPermission("asa")) {
            this.clickedEntityes.remove(entity.getUniqueId());
            this.removeDoor(door, p.getWorld());
            return;
        }
        if (door.locked) {
            FLogger.info("testing  llave");
            if (p.hasCooldown(hand) || !door.symbol.getKey().isThisItem(hand)) {
                if (this.cooldown(p)) {
                    return;
                }
                Bukkit.getOnlinePlayers().forEach(py -> py.playSound(py.getLocation(), "doors.force", SoundCategory.PLAYERS, 2.0f, 1.0f));
                return;
            }
            p.setCooldown(hand, 200);
            FLogger.info("llave paso");
        }
        this.clickedEntityes.add(entity.getUniqueId());
        final int frames = 10;
        int intervalo = 1;
        FLogger.info("valido");
        int ticksTotales = frames * intervalo;
        double desplazamientoportick = 2.0 / (double)ticksTotales;
        final double yawpertick = door.locked ? 90.0 / (double)ticksTotales : 80.0 / (double)ticksTotales;
        switch (door.yaw) {
            case 0: {
                double[] dArray2 = new double[4];
                dArray2[0] = 0.0;
                dArray2[1] = desplazamientoportick / 2.0;
                dArray2[2] = desplazamientoportick / 2.0;
                dArray = dArray2;
                dArray2[3] = 0.0;
                break;
            }
            case 90: {
                double[] dArray3 = new double[4];
                dArray3[0] = -desplazamientoportick / 2.0;
                dArray3[1] = 0.0;
                dArray3[2] = 0.0;
                dArray = dArray3;
                dArray3[3] = desplazamientoportick / 2.0;
                break;
            }
            case 180: {
                double[] dArray4 = new double[4];
                dArray4[0] = 0.0;
                dArray4[1] = -desplazamientoportick / 2.0;
                dArray4[2] = -desplazamientoportick / 2.0;
                dArray = dArray4;
                dArray4[3] = 0.0;
                break;
            }
            case -90: {
                double[] dArray5 = new double[4];
                dArray5[0] = desplazamientoportick / 2.0;
                dArray5[1] = 0.0;
                dArray5[2] = 0.0;
                dArray = dArray5;
                dArray5[3] = -desplazamientoportick / 2.0;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + door.yaw);
            }
        }
        final double[] dorMovment = dArray;
        final ArmorStand axis = (ArmorStand)p.getWorld().getEntity(door.axis);
        final ArmorStand carry = (ArmorStand)p.getWorld().getEntity(door.collision.stand);
        final Shulker colShulker = (Shulker)p.getWorld().getEntity(door.collision.shulker);
        if (axis == null || carry == null || colShulker == null) {
            this.doors.remove(door);
            FLogger.warning("puerta corrupta eliminada en" + p.getLocation().toString());
            return;
        }
        FLogger.info("nada nulo");
        int modifiquer = 0;
        if (door.opened) {
            Bukkit.getOnlinePlayers().forEach(py -> py.playSound(axis.getLocation(), "doors.open", SoundCategory.PLAYERS, 2.0f, 1.0f));
            modifiquer = 1;
        } else {
            Bukkit.getOnlinePlayers().forEach(py -> py.playSound(axis.getLocation(), "doors.close", SoundCategory.PLAYERS, 2.0f, 1.0f));
            modifiquer = -1;
        }
        door.setOpened(!door.opened);
        door.locked = false;
        final int finalModifiquer = modifiquer;
        new BukkitRunnable(){
            int i = 0;

            public void run() {
                if (this.i++ >= frames) {
                    FLogger.info("cancelado");
                    HideAndSeek.this.clickedEntityes.remove(entity.getUniqueId());
                    this.cancel();
                    if (bol) {
                        new BukkitRunnable(){

                            public void run() {
                                HideAndSeek.this.openNaNoor(entity, p, false);
                            }
                        }.runTaskLater((Plugin)SUHCore.instance, 40L);
                    }
                    return;
                }
                Location temp = axis.getLocation().clone();
                temp.setYaw((float)((double)axis.getLocation().getYaw() - yawpertick * (double)finalModifiquer));
                axis.teleport(temp);
                carry.removePassenger((Entity)colShulker);
                temp = carry.getLocation().clone();
                temp.setX(temp.getX() + dorMovment[2] * (double)finalModifiquer);
                temp.setZ(temp.getZ() + dorMovment[3] * (double)finalModifiquer);
                carry.teleport(temp);
                carry.addPassenger((Entity)colShulker);
            }
        }.runTaskTimer((Plugin)SUHCore.instance, 0L, (long)intervalo);
    }

    void summnoDoor(Player p, String sy) {
        double[] dArray;
        Symbol symbol = Symbol.valueOf(sy.toUpperCase());
        Location location = p.getLocation().clone();
        location.setX((double)location.getBlockX() + 0.5);
        location.setY((double)location.getBlockY());
        location.setZ((double)location.getBlockZ() + 0.5);
        int yaw = OffTopic.getNearestYawAngle(location.getYaw());
        location.setYaw((float)yaw);
        location.setPitch(0.0f);
        ArmorStand carry = (ArmorStand)location.getWorld().spawn(location.clone().add(0.0, -0.4, 0.0), ArmorStand.class);
        carry.setSmall(true);
        this.putStuffToAS(carry, "move");
        switch (yaw) {
            case 0: {
                double[] dArray2 = new double[2];
                dArray2[0] = -0.5;
                dArray = dArray2;
                dArray2[1] = 0.0;
                break;
            }
            case 90: {
                double[] dArray3 = new double[2];
                dArray3[0] = 0.0;
                dArray = dArray3;
                dArray3[1] = -0.5;
                break;
            }
            case 180: {
                double[] dArray4 = new double[2];
                dArray4[0] = 0.49;
                dArray = dArray4;
                dArray4[1] = 0.0;
                break;
            }
            case -90: {
                double[] dArray5 = new double[2];
                dArray5[0] = 0.0;
                dArray = dArray5;
                dArray5[1] = 0.49;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + yaw);
            }
        }
        double[] doorlocation = dArray;
        ArmorStand door = (ArmorStand)location.getWorld().spawn(location.clone().add(doorlocation[0], 0.0, doorlocation[1]), ArmorStand.class);
        this.putStuffToAS(door, "door");
        String symbolKey = "hsdoor_" + symbol.caracter.toLowerCase();
        door.getEquipment().setHelmet(FEntity.getItemstackWhitItemModel(Material.STICK, symbolKey));
        Shulker shulker = (Shulker)location.getWorld().spawn(location, Shulker.class);
        shulker.setGravity(false);
        shulker.setInvulnerable(true);
        shulker.setAI(false);
        shulker.setSilent(true);
        shulker.setInvisible(true);
        shulker.getScoreboardTags().add("door");
        shulker.getScoreboardTags().add("shulker");
        Collision collision = new Collision(carry.getUniqueId(), shulker.getUniqueId());
        Door doorObject = new Door(door.getUniqueId(), collision, symbol, yaw, true, false);
        FLogger.debugging("entidad generada en " + location.getWorld().getName() + " -> " + String.valueOf(doorObject));
        this.doors.add(doorObject);
        carry.addPassenger((Entity)shulker);
    }

    void putStuffToAS(ArmorStand stand, String id) {
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.HEAD});
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.CHEST});
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.LEGS});
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.FEET});
        stand.setGravity(false);
        stand.setBasePlate(false);
        stand.setArms(false);
        stand.setInvisible(true);
        stand.setInvulnerable(true);
        stand.getScoreboardTags().add(id);
        stand.getScoreboardTags().add("door");
    }

    @Override
    protected void saveMinigameData() {
        JSONArray doors = new JSONArray();
        for (Door door : this.doors) {
            JSONObject doorObject = new JSONObject();
            JSONObject collision = new JSONObject();
            collision.put("a", door.collision.stand.toString());
            collision.put("s", door.collision.shulker.toString());
            doorObject.put("collision", collision);
            doorObject.put("axis", door.axis);
            doorObject.put("yaw", door.yaw);
            doorObject.put("locked", door.locked);
            doorObject.put("symbol", door.symbol.toString());
            doorObject.put("opened", door.opened);
            doors.put(doorObject);
        }
        this.jsonMinigame.put("doors", doors);
    }

    private static class Door {
        public final UUID axis;
        public final Collision collision;
        public final Symbol symbol;
        public final Integer yaw;
        public boolean locked;
        public boolean opened;

        public Door(UUID axis, Collision collision, Symbol symbol, Integer yaw, boolean locked, boolean opened) {
            this.axis = axis;
            this.collision = collision;
            this.symbol = symbol;
            this.yaw = yaw;
            this.locked = locked;
            this.opened = opened;
        }

        public void setOpened(boolean opened) {
            this.opened = opened;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        public String toString() {
            return "Door{axis=" + String.valueOf(this.axis) + ", collision=" + String.valueOf(this.collision) + ", symbol=" + String.valueOf((Object)this.symbol) + ", yaw=" + this.yaw + ", locked=" + this.locked + ", opened=" + this.opened + "}";
        }
    }

    private record Collision(UUID stand, UUID shulker) {
        @Override
        @NotNull
        public String toString() {
            return "Collision{stand=" + String.valueOf(this.stand) + ", shulker=" + String.valueOf(this.shulker) + "}";
        }
    }

    private static enum Symbol {
        TRIANGLE("T", SUHItems.HS_LLAVE_T),
        SQUARE("S", SUHItems.HS_LLAVE_S),
        CIRCLE("C", SUHItems.HS_LLAVE_C);

        private final String caracter;
        private final SUHItems key;

        private Symbol(String caracter, SUHItems key) {
            this.caracter = caracter;
            this.key = key;
        }

        public SUHItems getKey() {
            return this.key;
        }

        public String getCaracter() {
            return this.caracter;
        }
    }
}

