/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.items.modItems.newItems;

import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.utils.logger.FLogger;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class FItemStask {
    private boolean craftable = false;
    private boolean inited = false;
    protected final ItemStack itemStack;
    private String key;
    public static final NamespacedKey NAMESPACED_KEY = new NamespacedKey((Plugin)SUHCore.instance, "fitemstask");

    public FItemStask(Material material) {
        this.itemStack = new ItemStack(material);
    }

    public final void initKey(String key) {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.key = key.toLowerCase();
        this.itemStack.editMeta(m -> {
            m.customName((Component)Component.text((String)key));
            m.getPersistentDataContainer().set(NAMESPACED_KEY, PersistentDataType.STRING, (Object)key.toLowerCase());
            this.initView((ItemMeta)m, NAMESPACED_KEY);
        });
        NamespacedKey craftKey = new NamespacedKey("fcraft", key.toLowerCase());
        ShapedRecipe recipe = new ShapedRecipe(craftKey, this.itemStack);
        this.makeRecipe(recipe);
        try {
            if (Bukkit.getRecipe((NamespacedKey)craftKey) == null) {
                if (Bukkit.addRecipe((Recipe)recipe)) {
                    FLogger.debugging("Item crafteable a\u00f1adido: " + key);
                }
                this.craftable = true;
            }
        }
        catch (NullPointerException e) {
            FLogger.debugging("Item no crafteable a\u00f1adido: " + key);
        }
        this.afterInitKey();
    }

    protected void afterInitKey() {
    }

    protected void makeRecipe(ShapedRecipe recipe) {
    }

    public final void setItemModel(ItemMeta m, String model) {
        m.setItemModel(new NamespacedKey("suhcore", model));
    }

    public abstract void initView(ItemMeta var1, NamespacedKey var2);

    public final ItemStack getItemStack() {
        return this.itemStack.clone();
    }

    public final boolean isThisItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.getType() != this.itemStack.getType()) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!container.has(NAMESPACED_KEY, PersistentDataType.STRING)) {
            return false;
        }
        String val = (String)container.get(NAMESPACED_KEY, PersistentDataType.STRING);
        return this.key != null && this.key.equals(val);
    }

    public final boolean hasPlayerThisItem(Player player, int discount) {
        boolean has = false;
        for (ItemStack stack : player.getInventory().getContents()) {
            if (stack == null || !this.isThisItem(stack)) continue;
            has = true;
            stack.setAmount(stack.getAmount() - discount);
            break;
        }
        return has;
    }

    public final boolean hasPlayerThisItem(Player player) {
        return this.hasPlayerThisItem(player, 0);
    }

    public final boolean hasPlayerThisItemInHotbar(Player player) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack == null || !this.isThisItem(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    public String getKey() {
        return this.key;
    }
}

