/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.utils;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import me.fixfis.sUHCore.SUHCore;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TemporaryAttributeManager
implements Listener {
    private static final Set<PlayerBuff> buffs = ConcurrentHashMap.newKeySet();

    public static void registerBuff(final Player player, final Attribute attribute, double value, String stringKey) {
        if (player == null || player.getAttribute(attribute) == null) {
            return;
        }
        NamespacedKey nsKey = new NamespacedKey("suhbuff", stringKey + attribute.getKey().getKey());
        PlayerBuff existing = null;
        for (PlayerBuff pb : buffs) {
            if (!pb.playerUUID().equals(player.getUniqueId()) || !pb.buff().key().equals((Object)nsKey)) continue;
            existing = pb;
            break;
        }
        if (existing != null) {
            BukkitTask oldTask = existing.task();
            if (oldTask != null) {
                oldTask.cancel();
            }
            final AtomicReference<PlayerBuff> holder = new AtomicReference<PlayerBuff>(existing);
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    PlayerBuff pb = (PlayerBuff)holder.get();
                    if (pb != null) {
                        buffs.remove(pb);
                        Player p = player;
                        AttributeInstance inst = p.getAttribute(pb.buff().attribute());
                        if (inst != null) {
                            inst.removeModifier(pb.buff().modifier());
                        }
                    }
                }
            };
            BukkitTask newTask = runnable.runTaskLater((Plugin)SUHCore.instance, 200L);
            PlayerBuff newBuff = new PlayerBuff(player.getUniqueId(), newTask, existing.buff());
            buffs.remove(existing);
            buffs.add(newBuff);
            holder.set(newBuff);
            return;
        }
        AttributeInstance attributeInstance = player.getAttribute(attribute);
        final AttributeModifier modifier = new AttributeModifier(nsKey, value, AttributeModifier.Operation.ADD_NUMBER);
        attributeInstance.addModifier(modifier);
        final AtomicReference<PlayerBuff> holder = new AtomicReference<PlayerBuff>();
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                AttributeInstance inst;
                PlayerBuff pb = (PlayerBuff)holder.get();
                if (pb != null) {
                    buffs.remove(pb);
                }
                if ((inst = player.getAttribute(attribute)) != null) {
                    inst.removeModifier(modifier);
                }
            }
        };
        BukkitTask task = runnable.runTaskLater((Plugin)SUHCore.instance, 200L);
        PlayerBuff newBuff = new PlayerBuff(player.getUniqueId(), task, new Buff(modifier, value, nsKey, attribute));
        holder.set(newBuff);
        buffs.add(newBuff);
    }

    public static void registerInfiniteBuff(Player player, Attribute attribute, double value, String stringKey) {
        if (player == null || player.getAttribute(attribute) == null) {
            return;
        }
        NamespacedKey nsKey = new NamespacedKey("suhbuff", stringKey);
        PlayerBuff existing = null;
        for (PlayerBuff pb : buffs) {
            if (!pb.playerUUID().equals(player.getUniqueId()) || !pb.buff().key().equals((Object)nsKey)) continue;
            existing = pb;
            break;
        }
        if (existing != null) {
            TemporaryAttributeManager.removeBuff(player, attribute, stringKey);
        }
        AttributeInstance attributeInstance = player.getAttribute(attribute);
        AttributeModifier modifier = new AttributeModifier(nsKey, value, AttributeModifier.Operation.ADD_NUMBER);
        attributeInstance.addModifier(modifier);
        PlayerBuff newBuff = new PlayerBuff(player.getUniqueId(), null, new Buff(modifier, value, nsKey, attribute));
        buffs.add(newBuff);
    }

    public static boolean removeBuff(Player player, Attribute attribute, String stringKey) {
        AttributeInstance inst;
        if (player == null) {
            return false;
        }
        NamespacedKey nsKey = new NamespacedKey("suhbuff", stringKey + attribute.getKey().getKey());
        PlayerBuff target = null;
        for (PlayerBuff pb : buffs) {
            if (!pb.playerUUID().equals(player.getUniqueId()) || !pb.buff().key().equals((Object)nsKey)) continue;
            target = pb;
            break;
        }
        if (target == null) {
            return false;
        }
        BukkitTask t = target.task();
        if (t != null) {
            t.cancel();
        }
        if ((inst = player.getAttribute(target.buff().attribute())) != null) {
            inst.removeModifier(target.buff().modifier());
        }
        buffs.remove(target);
        return true;
    }

    public static void removeAllPlayerBuffs(Player player) {
        if (player == null) {
            return;
        }
        List<PlayerBuff> toRemove = buffs.stream().filter(pb -> pb.playerUUID().equals(player.getUniqueId())).toList();
        for (PlayerBuff pb2 : toRemove) {
            AttributeInstance inst;
            BukkitTask t = pb2.task();
            if (t != null) {
                t.cancel();
            }
            if ((inst = player.getAttribute(pb2.buff().attribute())) != null) {
                inst.removeModifier(pb2.buff().modifier());
            }
            buffs.remove(pb2);
        }
    }

    public static void removeAllBuffs() {
        List snapshot = buffs.stream().toList();
        for (PlayerBuff pb : snapshot) {
            AttributeInstance inst;
            Player p;
            BukkitTask t = pb.task();
            if (t != null) {
                t.cancel();
            }
            if ((p = SUHCore.instance.getServer().getPlayer(pb.playerUUID())) != null && (inst = p.getAttribute(pb.buff().attribute())) != null) {
                inst.removeModifier(pb.buff().modifier());
            }
            buffs.remove(pb);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        TemporaryAttributeManager.removeAllPlayerBuffs(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        TemporaryAttributeManager.removeAllPlayerBuffs(e.getPlayer());
    }

    @EventHandler
    public void onKick(PlayerKickEvent e) {
        TemporaryAttributeManager.removeAllPlayerBuffs(e.getPlayer());
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent e) {
        TemporaryAttributeManager.removeAllPlayerBuffs(e.getEntity());
    }

    public record PlayerBuff(UUID playerUUID, BukkitTask task, Buff buff) {
    }

    public record Buff(AttributeModifier modifier, double value, NamespacedKey key, Attribute attribute) {
    }
}

