/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs.bosses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.mobs.bosses.BossEntityConfig;
import me.fixfis.sUHCore.mobs.bosses.moded.BombaEntity;
import me.fixfis.sUHCore.mobs.bosses.moded.JennysMod;
import me.fixfis.sUHCore.mobs.bosses.moded.LombrizEntity;
import me.fixfis.sUHCore.mobs.bosses.moded.SUHPortal;
import me.fixfis.sUHCore.sever_client.ClientUtils;
import me.fixfis.sUHCore.utils.logger.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public abstract class FBossEntity
implements Listener {
    public static final HashMap<UUID, FBossEntity> livingBosses = new HashMap();
    public static final Map<String, Class<? extends FBossEntity>> bossClasses = new HashMap<String, Class<? extends FBossEntity>>();
    public static final Map<String, List<String>> bossAnimations = new HashMap<String, List<String>>();
    final Interaction entity;
    final String key;
    final Integer maxHealth;
    final Integer percepcionRadius;
    final Integer width;
    final Integer high;
    Integer healt;
    protected List<ControllerRecord> controllers = new ArrayList<ControllerRecord>();
    Integer currentLivedTime = 0;
    TargetEntity target = null;
    Boolean isTargeting = false;

    public static void initBossesClasses() {
        bossClasses.put("jennys", JennysMod.class);
        bossClasses.put("lombriz", LombrizEntity.class);
        bossClasses.put("suhportal", SUHPortal.class);
        bossClasses.put("bomba", BombaEntity.class);
    }

    public static void initBossesAnimations() {
        bossAnimations.put("jennys", JennysMod.ANIMATIONS);
        bossAnimations.put("lombriz", LombrizEntity.ANIMATIONS);
        bossAnimations.put("suhportal", SUHPortal.ANIMATIONS);
        bossAnimations.put("bomba", BombaEntity.ANIMATIONS);
    }

    public abstract List<String> animations();

    public FBossEntity(String key, Integer maxHealth, Integer percepcionRadius, Integer width, Integer high, Location location) {
        this.key = key;
        this.maxHealth = maxHealth;
        this.percepcionRadius = percepcionRadius;
        this.width = width;
        this.high = high;
        this.healt = maxHealth;
        this.entity = this.summonEntity(location);
        SUHCore.instance.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)SUHCore.instance);
        if (!BossEntityConfig.bossConfig.containsKey(key)) {
            BossEntityConfig.bossConfig.put(key, new ArrayList());
        }
        BossEntityConfig.bossConfig.get(key).add(this.entity.getUniqueId().toString());
        if (this.spawnAnimation() != null) {
            this.playAnimation(this.spawnAnimation().emerg, "hold");
            new BukkitRunnable(){

                public void run() {
                    FBossEntity.this.playAnimation(FBossEntity.this.spawnAnimation().idle, "loop");
                    this.cancel();
                }
            }.runTaskLater((Plugin)SUHCore.instance, this.spawnAnimation().ticks.longValue());
        }
        if (percepcionRadius != null) {
            this.initBossIA();
        }
        livingBosses.put(this.entity.getUniqueId(), this);
    }

    protected SpawnAnimation spawnAnimation() {
        return null;
    }

    private Interaction summonEntity(Location location) {
        Interaction i = (Interaction)location.getWorld().spawn(location, Interaction.class);
        i.getScoreboardTags().add("fboss");
        i.getScoreboardTags().add("@" + this.key);
        i.setInteractionHeight((float)this.high.intValue());
        i.setInteractionWidth((float)this.width.intValue());
        Bukkit.getOnlinePlayers().forEach(player -> ClientUtils.sendDataToClient(player, "entity", this.key + "_" + String.valueOf(i.getUniqueId())));
        this.onBossSpawn(i);
        return i;
    }

    public final void playAnimation(String anim, String loopType) {
        if (!this.animations().contains(anim)) {
            FLogger.warning("Animation not found : " + anim);
            return;
        }
        Bukkit.getOnlinePlayers().forEach(player -> ClientUtils.sendDataToClient(player, "playAnimEntity", this.key + "_" + String.valueOf(this.entity.getUniqueId()) + "_" + anim + "_" + loopType));
    }

    @EventHandler
    public final void onRightClick(PlayerInteractAtEntityEvent event) {
        Interaction interaction;
        Entity entity = event.getRightClicked();
        if (entity instanceof Interaction && (interaction = (Interaction)entity).getUniqueId().equals(this.entity.getUniqueId())) {
            ItemStack stack;
            Player player = event.getPlayer();
            if (event.getHand() == EquipmentSlot.HAND && (stack = event.getPlayer().getInventory().getItemInMainHand()).getType() == Material.TARGET) {
                this.killThisEntity();
                return;
            }
            this.onBossInteractedByPlayer(interaction, player);
        }
    }

    @EventHandler
    public final void onAttack(EntityDamageByEntityEvent event) {
        Interaction interaction;
        Entity entity = event.getEntity();
        if (entity instanceof Interaction && (interaction = (Interaction)entity).getUniqueId().equals(this.entity.getUniqueId())) {
            Entity entity2 = event.getDamager();
            if (entity2 instanceof Player) {
                player = (Player)entity2;
                this.onBossDamaged(interaction, (Player)player);
            }
        } else {
            Entity entity3;
            Interaction interaction2;
            player = event.getDamager();
            if (player instanceof Interaction && (interaction2 = (Interaction)player).getUniqueId().equals(this.entity.getUniqueId()) && (entity3 = event.getEntity()) instanceof Player) {
                player = (Player)entity3;
                this.onBossDamage(interaction2, (Player)player);
            }
        }
    }

    protected void onBossDeath(Interaction boss) {
    }

    protected void onBossSpawn(Interaction boss) {
    }

    protected void onBossInteractedByPlayer(Interaction boss, Player player) {
    }

    protected void onBossDamaged(Interaction boss, Player entity) {
    }

    protected void onBossDamage(Interaction boss, Player entity) {
    }

    protected void onBossTarget(Interaction boss, Player entity) {
    }

    protected Integer secondsToTicks(Double seconds) {
        return (int)(seconds * 20.0);
    }

    public final void addController(Controller controller, int min, int max) {
        this.controllers.add(new ControllerRecord(controller, min, max));
    }

    public final void damagePlayer(LivingEntity entity, double damage) {
        entity.damage(damage, DamageSource.builder((DamageType)DamageType.MOB_ATTACK).withDirectEntity((Entity)entity).withDamageLocation(entity.getLocation()).build());
    }

    public final void entityHealth(int value) {
        this.healt = this.healt + value;
        if (this.healt > this.maxHealth) {
            this.healt = this.maxHealth;
        }
    }

    public final void killThisEntity() {
        HandlerList.unregisterAll((Listener)this);
        Bukkit.getOnlinePlayers().forEach(player -> ClientUtils.sendDataToClient(player, "killEntity", this.key + "_" + String.valueOf(this.entity.getUniqueId())));
        BossEntityConfig.bossConfig.get(this.key).remove(this.entity.getUniqueId().toString());
        this.onBossDeath(this.entity);
        this.entity.remove();
    }

    public void initBossIA() {
        new BukkitRunnable(){
            Controller currentController = null;

            public void run() {
                Integer n = FBossEntity.this.currentLivedTime;
                FBossEntity.this.currentLivedTime = FBossEntity.this.currentLivedTime + 1;
                if ((double)FBossEntity.this.currentLivedTime.intValue() <= 50.0) {
                    return;
                }
                if (FBossEntity.this.healt <= 0) {
                    this.cancel();
                    FBossEntity.this.killThisEntity();
                }
                if (FBossEntity.this.entity == null) {
                    this.cancel();
                    return;
                }
                if (FBossEntity.this.target != null) {
                    if (!FBossEntity.this.isTargeting.booleanValue() && FBossEntity.this.target.time + 100 <= FBossEntity.this.currentLivedTime) {
                        FBossEntity.this.target = null;
                    } else if (this.currentController != null) {
                        FBossEntity.this.isTargeting = true;
                        if (this.currentController.run(FBossEntity.this.entity, FBossEntity.this.target.entity, FBossEntity.this.currentLivedTime)) {
                            this.currentController = null;
                            FBossEntity.this.target = null;
                            FBossEntity.this.isTargeting = false;
                        }
                    } else if (!FBossEntity.this.controllers.isEmpty()) {
                        double distance = FBossEntity.this.entity.getLocation().distance(FBossEntity.this.target.entity.getLocation());
                        FLogger.info("distancia " + distance);
                        ArrayList<Controller> candidatos = new ArrayList<Controller>();
                        for (ControllerRecord controller : FBossEntity.this.controllers) {
                            if (!((double)controller.min <= distance) || !(distance <= (double)controller.max)) continue;
                            candidatos.add(controller.controller);
                        }
                        if (!candidatos.isEmpty()) {
                            int random = ThreadLocalRandom.current().nextInt(candidatos.size());
                            this.currentController = (Controller)candidatos.get(random);
                        }
                    }
                }
                if (FBossEntity.this.target == null) {
                    Entity player = FBossEntity.this.entity.getNearbyEntities((double)FBossEntity.this.percepcionRadius.intValue(), (double)FBossEntity.this.percepcionRadius.intValue(), (double)FBossEntity.this.percepcionRadius.intValue()).stream().filter(e -> {
                        Player p;
                        return e instanceof Player && (p = (Player)e).getGameMode() == GameMode.SURVIVAL;
                    }).findFirst().orElse(null);
                    if (player == null) {
                        return;
                    }
                    FBossEntity.this.target = new TargetEntity((Player)player, FBossEntity.this.currentLivedTime);
                    FBossEntity.this.onBossTarget(FBossEntity.this.entity, FBossEntity.this.target.entity);
                }
            }
        }.runTaskTimer((Plugin)SUHCore.instance, 0L, 1L);
    }

    Integer distance(Location pos, Location entity) {
        return (int)Math.sqrt(Math.pow(pos.getX() - entity.getX(), 2.0) + Math.pow(pos.getY() - entity.getY(), 2.0) + Math.pow(pos.getZ() - entity.getZ(), 2.0));
    }

    protected final Location getLookLocation(Location base, double distance) {
        Location origin = base.clone();
        Vector dir = origin.getDirection().normalize().multiply(distance);
        return origin.clone().add(dir);
    }

    protected final Location ubicacionEntity(Entity entity) {
        Block block = entity.getLocation().getBlock();
        while (block.getType() == Material.AIR && block.getY() > entity.getWorld().getMinHeight()) {
            block = block.getRelative(BlockFace.DOWN);
        }
        return block.getLocation().add(0.5, 1.0, 0.5);
    }

    protected final void lookAtTarget(Entity entity, Entity target) {
        Location playerLoc = entity.getLocation();
        Location targetLoc = target.getLocation();
        double dx = targetLoc.getX() - playerLoc.getX();
        double dz = targetLoc.getZ() - playerLoc.getZ();
        float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
        Location teleportLocation = playerLoc.clone();
        teleportLocation.setYaw(yaw);
        teleportLocation.setPitch(0.0f);
        entity.teleport(teleportLocation);
    }

    public void putDefautlEntitySize() {
        this.entity.setInteractionHeight((float)this.high.intValue());
        this.entity.setInteractionWidth((float)this.width.intValue());
    }

    public final void putEntitySize(int width, int high) {
        this.entity.setInteractionHeight((float)high);
        this.entity.setInteractionWidth((float)width);
    }

    public Interaction getEntity() {
        return this.entity;
    }

    public String getKey() {
        return this.key;
    }

    record TargetEntity(Player entity, Integer time) {
    }

    public record SpawnAnimation(String emerg, String idle, Long ticks) {
    }

    public record ControllerRecord(Controller controller, int min, int max) {
    }

    @FunctionalInterface
    public static interface Controller {
        public boolean run(Interaction var1, Player var2, Integer var3);
    }
}

