/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.specialEvents.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.mobs.SUHMobs;
import me.fixfis.sUHCore.utils.Texto;
import me.fixfis.sUHCore.utils.logger.FLogger;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SoulContainer
implements Listener {
    private static final Map<UUID, SoulContainer> soulContainers = new HashMap<UUID, SoulContainer>();
    private final List<Zombie> plebes = new ArrayList<Zombie>();
    private final UUID playeruuid;
    private Integer souls;

    public static SoulContainer getSoulContainer(Player player) {
        SoulContainer s = soulContainers.get(player.getUniqueId());
        if (s == null) {
            s = new SoulContainer(player);
            soulContainers.put(player.getUniqueId(), s);
        }
        return s;
    }

    public SoulContainer(Player player) {
        this.playeruuid = player.getUniqueId();
        SUHCore.instance.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)SUHCore.instance);
        FLogger.info("creado SoulContainer para " + player.getName());
        this.souls = 0;
    }

    public void onKill(Entity entity) {
        Player player = Bukkit.getPlayer((UUID)this.playeruuid);
        if (player == null) {
            return;
        }
        if (entity instanceof Monster) {
            this.onSoulGained(player);
        }
    }

    public void onInvoke() {
        Player player = Bukkit.getPlayer((UUID)this.playeruuid);
        if (this.souls >= 5 && player != null) {
            this.souls = 0;
            for (int i = 0; i < 3; ++i) {
                final Zombie z = (Zombie)SUHMobs.ZOMBIE_PLEBE.getfEntity().summonEntity(player.getLocation());
                new BukkitRunnable(this){

                    public void run() {
                        if (z.isDead()) {
                            this.cancel();
                        }
                        z.damage(4.0);
                    }
                }.runTaskTimer((Plugin)SUHCore.instance, 200L, 20L);
                this.plebes.add(z);
            }
        } else {
            player.sendActionBar((Component)Component.text((String)Texto.aColor("&5(" + this.souls + "/5)")));
        }
    }

    void onSoulGained(Player player) {
        if (this.souls < 5) {
            Integer n = this.souls;
            this.souls = this.souls + 1;
        }
        player.sendActionBar((Component)Component.text((String)Texto.aColor("&5(" + this.souls + "/5)")));
    }

    @EventHandler
    public void onPlayerPVP(EntityDamageByEntityEvent e) {
        Player damaged;
        Entity entity = e.getEntity();
        if (entity instanceof Player && (damaged = (Player)entity).getUniqueId().equals(this.playeruuid) && (entity = e.getDamager()) instanceof LivingEntity) {
            LivingEntity damager = (LivingEntity)entity;
            this.setTargetForPlebe(damaged, damager);
        } else {
            Player damager;
            entity = e.getDamager();
            if (entity instanceof Player && (damager = (Player)entity).getUniqueId().equals(this.playeruuid) && (entity = e.getEntity()) instanceof LivingEntity) {
                LivingEntity damaged2 = (LivingEntity)entity;
                this.setTargetForPlebe(damager, damaged2);
            }
        }
    }

    private void setTargetForPlebe(Player player, LivingEntity entity) {
        this.plebes.removeIf(zombie -> zombie == null || zombie.isDead() || !zombie.isValid());
        for (Zombie plebe : this.plebes) {
            plebe.setTarget(entity);
        }
    }
}

