/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs.modMobs.mobs;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FEntity;
import me.fixfis.sUHCore.sever_client.ClientUtils;
import me.fixfis.sUHCore.utils.logger.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class FInteraction
extends FEntity<Interaction>
implements Listener {
    private final Set<UUID> livingOnes = new HashSet<UUID>();
    final float width;
    final float height;
    private final Set<InteractionEvent> events = new HashSet<InteractionEvent>();

    public FInteraction(String keyName, float width, float height) {
        super(Interaction.class, keyName);
        this.width = width;
        this.height = height;
    }

    public final void load() {
        JSONObject json = SUHCore.FILEinteractionsEntities;
        if (json.has(this.getKeyName())) {
            JSONArray uuids = json.getJSONArray(this.getKeyName());
            uuids.toList().stream().filter(o -> o instanceof String).map(o -> (String)o).map(UUID::fromString).forEach(this.livingOnes::add);
        } else {
            SUHCore.FILEinteractionsEntities.put(this.getKeyName(), new JSONArray());
        }
    }

    public final void save() {
        JSONArray array = new JSONArray((Collection<?>)this.livingOnes.stream().map(UUID::toString).toList());
        SUHCore.FILEinteractionsEntities.put(this.getKeyName(), array);
    }

    @Override
    protected final void initViewEntity(Interaction entity) {
        entity.setInteractionHeight(this.height);
        entity.setInteractionWidth(this.width);
        this.addLivingOne(entity.getUniqueId());
    }

    void addLivingOne(UUID uuid) {
        this.livingOnes.add(uuid);
        Bukkit.getOnlinePlayers().forEach(player -> ClientUtils.sendDataToClient(player, "entity", this.getKeyName() + "_" + String.valueOf(uuid)));
    }

    void removeLivingOne(Interaction entity) {
        Bukkit.getOnlinePlayers().forEach(player -> ClientUtils.sendDataToClient(player, "killEntity", this.getKeyName() + "_" + String.valueOf(entity.getUniqueId())));
        entity.remove();
        this.livingOnes.remove(entity.getUniqueId());
    }

    public final PlayingAnimation playAnimation(String anim, Interaction interaction, String loopType) {
        if (!this.animations().contains(anim)) {
            FLogger.warning("Animation not found : " + anim);
            return new PlayingAnimation(interaction, this.getKeyName());
        }
        Bukkit.getOnlinePlayers().forEach(player -> ClientUtils.sendDataToClient(player, "playAnimEntity", this.getKeyName() + "_" + String.valueOf(interaction.getUniqueId()) + "_" + anim + "_" + loopType));
        return new PlayingAnimation(interaction, this.getKeyName());
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerJoin(PlayerJoinEvent event) {
        this.livingOnes.forEach(uuid -> ClientUtils.sendDataToClient(event.getPlayer(), "entity", this.getKeyName() + "_" + String.valueOf(uuid)));
    }

    @EventHandler
    public final void onRightClickAtEntity(PlayerInteractAtEntityEvent event) {
        if (this.isThisEntity(event.getRightClicked())) {
            ItemStack item = event.getPlayer().getInventory().getItemInMainHand();
            if (item.getType() == Material.TARGET) {
                this.removeLivingOne((Interaction)event.getRightClicked());
                return;
            }
            this.onRightClickAtEntityEvent(event.getPlayer(), (Interaction)event.getRightClicked(), event);
            this.events.forEach(e -> e.onEvent(event.getPlayer(), (Interaction)event.getRightClicked()));
        }
    }

    public abstract void onRightClickAtEntityEvent(@NotNull Player var1, Interaction var2, PlayerInteractAtEntityEvent var3);

    public final void addEvent(InteractionEvent event) {
        this.events.add(event);
    }

    public abstract List<String> animations();

    public static class PlayingAnimation {
        private Integer ticks = 0;
        private final String keyname;
        private final Interaction interaction;

        public PlayingAnimation(Interaction interaction, String keyname) {
            this.keyname = keyname;
            this.interaction = interaction;
        }

        public PlayingAnimation then(int delayTicks, final String loopType, final String anim) {
            this.ticks = this.ticks + delayTicks;
            new BukkitRunnable(){

                public void run() {
                    Bukkit.getOnlinePlayers().forEach(player -> ClientUtils.sendDataToClient(player, "playAnimEntity", keyname + "_" + String.valueOf(interaction.getUniqueId()) + "_" + anim + "_" + loopType));
                }
            }.runTaskLater((Plugin)SUHCore.instance, (long)this.ticks.intValue());
            return this;
        }
    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public void onEvent(Player var1, Interaction var2);
    }
}

