/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.items.modItems.newItems;

import java.util.List;
import me.fixfis.sUHCore.items.modItems.newItems.FItemStask;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.components.EquippableComponent;

public abstract class FItemArmor
extends FItemStask {
    private List<ArmAtt> attributes;

    public FItemArmor(EquipmentSlot slot, Material material, String armorModel, List<ArmAtt> attributes) {
        super(material);
        this.attributes = attributes;
        EquippableComponent component = this.modifyArmor(new ItemStack(Material.LEATHER_HELMET).getItemMeta().getEquippable());
        this.itemStack.editMeta(m -> {
            m.setMaxStackSize(Integer.valueOf(1));
            if (armorModel != null) {
                component.setModel(new NamespacedKey("suhcore", armorModel));
            }
            component.setSlot(slot);
            m.setEquippable(component);
        });
    }

    public FItemArmor(EquipmentSlot slot, String armorModel) {
        this(slot, armorModel, null);
    }

    public FItemArmor(EquipmentSlot slot, String armorModel, List<ArmAtt> attributes) {
        this(slot, Material.STICK, armorModel, attributes);
    }

    @Override
    protected void afterInitKey() {
        this.itemStack.editMeta(m -> {
            if (this.attributes != null) {
                this.attributes.forEach(attribute -> m.addAttributeModifier(attribute.attribute, new AttributeModifier(new NamespacedKey("suhcore", this.getKey()), attribute.amount, AttributeModifier.Operation.ADD_NUMBER)));
            }
        });
    }

    public EquippableComponent modifyArmor(EquippableComponent component) {
        return component;
    }

    public record ArmAtt(Attribute attribute, double amount) {
    }
}

