/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.whitelist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import me.fixfis.stuff.LocalLogger;
import org.json.JSONObject;

public class Conexion {
    final String url;

    public Conexion(String url, JSONObject data, Callback callback) {
        this.url = url;
        new Thread(() -> {
            JSONObject response = null;
            response = data != null ? this.postJson(url, data) : this.jsonFromUrl(url);
            callback.onResponse(response);
        }).start();
    }

    public Conexion(String url, Callback callback) {
        this(url, null, callback);
    }

    private JSONObject postJson(String urlString, JSONObject data) {
        try {
            URL url = new URI(urlString).toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = data.toString().getBytes(StandardCharsets.UTF_8);
                os.write(input);
            }
            StringBuilder response = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    response.append(line);
                }
            }
            conn.disconnect();
            return new JSONObject(response.toString());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject jsonFromUrl(String urlString) {
        LocalLogger.logger(urlString);
        try {
            URL url = new URI(urlString).toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            InputStreamReader reader = new InputStreamReader(conn.getInputStream());
            StringBuilder result = new StringBuilder();
            int data = reader.read();
            while (data != -1) {
                result.append((char)data);
                data = reader.read();
            }
            reader.close();
            conn.disconnect();
            return new JSONObject(result.toString());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Callback {
        public void onResponse(JSONObject var1);
    }
}

