/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.utils;

import me.fixfis.sUHCore.items.SUHItems;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class OffTopic {
    public static void applyGlow(Player entity, ChatColor color, String teamName) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam(teamName);
        if (team == null) {
            team = scoreboard.registerNewTeam(teamName);
            team.setColor(color);
        }
        team.addPlayer((OfflinePlayer)entity);
        entity.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, -1, 1, false, false));
    }

    public static void removeGlow(String teamName) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam(teamName);
        if (team == null) {
            return;
        }
        team.unregister();
        Bukkit.getOnlinePlayers().forEach(player -> player.removePotionEffect(PotionEffectType.GLOWING));
    }

    public static void blockPlayerSlots(Player player) {
        for (int i = 39; i >= 36; --i) {
            int enumIndex = 39 - i;
            player.getInventory().setItem(i, SUHItems.valueOf("BLOCKEDARMOR" + enumIndex).getItemStack());
        }
    }

    public static int getNearestYawAngle(float yaw) {
        int[] possibleAngles = new int[]{-135, -90, -45, 0, 45, 90, 135, 180};
        int closest = possibleAngles[0];
        float minDiff = OffTopic.getAngleDifference(yaw, closest);
        for (int angle : possibleAngles) {
            float diff = OffTopic.getAngleDifference(yaw, angle);
            if (!(diff < minDiff)) continue;
            minDiff = diff;
            closest = angle;
        }
        return closest;
    }

    private static float getAngleDifference(float a, float b) {
        return Math.abs(((a - b + 180.0f) % 360.0f + 360.0f) % 360.0f - 180.0f);
    }

    public static int getOpsiteYaw(int yaw) {
        return switch (yaw) {
            case -135 -> 45;
            case -90 -> 90;
            case -45 -> 135;
            case 0 -> 180;
            case 45 -> -135;
            case 90 -> -90;
            case 135 -> -45;
            case 180 -> 0;
            default -> throw new IllegalStateException("Unexpected value: " + yaw);
        };
    }
}

