/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.stuff;

import com.destroystokyo.paper.event.block.BlockDestroyEvent;
import java.util.HashMap;
import java.util.UUID;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.config.SUHGenericConfig;
import me.fixfis.sUHCore.events.SUHEvents;
import me.fixfis.sUHCore.items.modItems.CrearItem;
import me.fixfis.sUHCore.muertes.Muertos;
import me.fixfis.sUHCore.muertes.Revivir;
import me.fixfis.sUHCore.muertes.interfaz.RevivirIntefaz;
import me.fixfis.sUHCore.sever_client.ClientUtils;
import me.fixfis.sUHCore.utils.OffTopic;
import me.fixfis.sUHCore.utils.Texto;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FLISTENER
implements Listener {
    private final HashMap<UUID, BukkitRunnable> playersInList = new HashMap();

    @EventHandler
    public final void onPlayerDestroyBlock(BlockDestroyEvent event) {
        if (event.getBlock().getType() == Material.COBWEB && SUHEvents.SPIDERS_ON_COBWEB.isEnabled()) {
            event.getBlock().getLocation().getWorld().spawn(event.getBlock().getLocation(), CaveSpider.class);
        }
    }

    @EventHandler
    public final void onEntityDamage(PlayerTeleportEvent event) {
        if (event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) && !SUHEvents.ALLOW_NETHER.isEnabled()) {
            event.setCancelled(true);
        } else if (event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.END_PORTAL) && !SUHEvents.ALLOW_END.isEnabled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            final Player player = (Player)entity;
            final UUID playerUUID = player.getUniqueId();
            BukkitRunnable task = new BukkitRunnable(){

                public void run() {
                    FLISTENER.this.playersInList.remove(playerUUID);
                    player.sendMessage("Tu tiempo ha expirado.");
                }
            };
            if (this.playersInList.containsKey(playerUUID)) {
                this.playersInList.get(playerUUID).cancel();
            }
            task.runTaskLater((Plugin)SUHCore.instance, 200L);
            this.playersInList.put(playerUUID, task);
        }
    }

    @EventHandler
    public final void onInventoryClick(InventoryClickEvent event) {
        RevivirIntefaz ri = RevivirIntefaz.isInList((Player)event.getWhoClicked());
        if (ri != null) {
            ri.onSelectEvent(event);
        }
    }

    @EventHandler
    public final void onInvnetoryClose(InventoryCloseEvent event) {
        RevivirIntefaz.deletoFrom((Player)event.getPlayer());
    }

    @EventHandler
    public final void onPlayerJoin(PlayerJoinEvent event) {
        if (event.getPlayer().hasPlayedBefore()) {
            OffTopic.blockPlayerSlots(event.getPlayer());
            event.getPlayer().teleport(SUHGenericConfig.SPAWN_LOC.getConfig().parseToLocation());
        }
        if (Revivir.isRevivido(event.getPlayer().getUniqueId())) {
            Revivir.revivir(event.getPlayer());
        }
        if (SUHEvents.BLOOD_MOON.isEnabled()) {
            this.runeable("isBloodMoon", event.getPlayer());
        }
        if (SUHEvents.ACID_RAIN.isEnabled()) {
            this.runeable("isAcidRain", event.getPlayer());
        }
    }

    final void runeable(final String data, final Player player) {
        new BukkitRunnable(this){

            public void run() {
                ClientUtils.sendDataToClient(player, data, 1);
            }
        }.runTaskLater((Plugin)SUHCore.instance, 20L);
    }

    @EventHandler
    public final void onPlayerLogin(PlayerLoginEvent event) {
        if (Muertos.isMuerto(event.getPlayer().getUniqueId())) {
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, (Component)Component.text((String)Texto.aColor("&5estas muerto")));
        }
    }

    @EventHandler
    public final void onPlayerDeath(PlayerDeathEvent event) {
        event.setCancelled(true);
        if (!event.getPlayer().hasPermission("admin")) {
            Muertos.playerDead(event.getPlayer());
        }
    }

    @EventHandler
    public final void onPrepareCraft(PrepareItemCraftEvent event) {
        CraftingInventory inventory = event.getInventory();
        for (ItemStack item : inventory.getMatrix()) {
            ItemMeta meta;
            if (item == null || item.getType() == Material.AIR || (meta = item.getItemMeta()) == null || !meta.hasCustomModelData() && !meta.getPersistentDataContainer().has(CrearItem.customItemKey) || inventory.getResult() == null || !inventory.getResult().hasItemMeta() || inventory.getResult().getItemMeta().getPersistentDataContainer().has(CrearItem.customItemKey)) continue;
            inventory.setResult(null);
            return;
        }
    }
}

