/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs;

import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.items.SUHItems;
import me.fixfis.sUHCore.mobs.modMobs.EntityAttributes;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FEntity;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FLivingEntities;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FMonster;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FStandEntity;
import me.fixfis.sUHCore.sever_client.ClientUtils;
import me.fixfis.sUHCore.sever_client.maps.EncadenadoMap;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public enum SUHMobs {
    ZOMBIE_SCRAMBLE((FEntity<? extends Entity>)new FMonster<Zombie>(Zombie.class, "zombieScramble", EntityAttributes.ZOMBIE){

        @Override
        public void initViewMonster(Zombie entity) {
            entity.getEquipment().setHelmet(1.getInvibleHelmet(Material.STICK));
            entity.setCustomName("Zombie Scramble");
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Zombie entity, Player player, EntityDamageByEntityEvent event) {
            PlayerInventory inventory = player.getInventory();
            ArrayList<ItemStack> itemsToShuffle = new ArrayList<ItemStack>();
            for (int slot = 0; slot <= 35; ++slot) {
                itemsToShuffle.add(inventory.getItem(slot));
            }
            itemsToShuffle.add(inventory.getItem(40));
            Collections.shuffle(itemsToShuffle);
            int index = 0;
            for (int slot = 0; slot <= 35; ++slot) {
                inventory.setItem(slot, (ItemStack)itemsToShuffle.get(index++));
            }
            inventory.setItem(40, (ItemStack)itemsToShuffle.get(index));
        }
    }),
    SKELETON_COBWEB((FEntity<? extends Entity>)new FMonster<Skeleton>(Skeleton.class, "skeletonCobweb", EntityAttributes.SKELETON){

        @Override
        public void initViewMonster(Skeleton entity) {
            entity.getEquipment().setHelmet(2.getInvibleHelmet(Material.COBWEB));
            entity.setCustomName("Skeleton Cobweb");
        }

        @Override
        protected void onPlayerDamagedByThisEntityByArrow(Arrow arrow, Skeleton entity, Player player, EntityDamageByEntityEvent event) {
            player.getLocation().getBlock().setType(Material.COBWEB);
        }
    }),
    SKELETON_TP((FEntity<? extends Entity>)new FMonster<Skeleton>(Skeleton.class, "skeletonTpwa", EntityAttributes.SKELETON){

        @Override
        public void initViewMonster(Skeleton entity) {
            entity.getEquipment().setHelmet(3.getInvibleHelmet(Material.END_STONE));
            entity.setCustomName("Skeleton TP");
        }

        @Override
        protected void onPlayerDamagedByThisEntityByArrow(Arrow arrow, Skeleton entity, Player player, EntityDamageByEntityEvent event) {
            Location sklc = entity.getLocation();
            sklc.getWorld().spawnEntity(sklc, EntityType.EVOKER_FANGS);
            entity.teleport(player.getLocation());
            player.teleport(sklc);
            player.sendMessage("deda");
        }
    }),
    CREEPER_SCRAMBLE((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeperScramble", EntityAttributes.CREEPER){
        private final Map<UUID, BukkitRunnable> scramblePlayers = new HashMap<UUID, BukkitRunnable>();

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(4.getInvibleHelmet(Material.SLIME_BALL));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, final Player player, EntityDamageByEntityEvent event) {
            BukkitRunnable task = new BukkitRunnable(){

                public void run() {
                    scramblePlayers.remove(player.getUniqueId());
                    ClientUtils.sendDataToClient(player, "scrambled", 0);
                }
            };
            if (this.scramblePlayers.containsKey(player.getUniqueId())) {
                this.scramblePlayers.get(player.getUniqueId()).cancel();
            }
            ClientUtils.sendDataToClient(player, "scrambled", 1);
            task.runTaskLater((Plugin)SUHCore.instance, 200L);
            this.scramblePlayers.put(player.getUniqueId(), task);
        }
    }),
    CREEPER_TNT((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeper_tnt", EntityAttributes.CREEPER){

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(5.getInvibleHelmet(Material.TNT));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, Player player, EntityDamageByEntityEvent event) {
            player.playSound((Entity)player, "entity.tin", 1.0f, 1.0f);
        }
    }),
    CREEPER_BOMBA((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeperBomba", EntityAttributes.CREEPER){

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(new ItemStack(Material.PAPER));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, Player player, EntityDamageByEntityEvent event) {
            EncadenadoMap.addUser(player);
        }
    }),
    CREEPER_FLASH((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeper_flash", EntityAttributes.CREEPER){

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(new ItemStack(Material.PAPER));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, Player player, EntityDamageByEntityEvent event) {
            ClientUtils.sendDataToClient(player, "flashed", 1);
            player.playSound((Entity)player, "entity.tin", 1.0f, 1.0f);
        }
    }),
    ORE_TITANIUM((FEntity<? extends Entity>)new FLivingEntities<Zombie>(Zombie.class, "ore_titanium"){

        @Override
        protected void initViewPeaceful(Zombie entity) {
            entity.setAI(false);
            entity.setSilent(true);
            entity.setInvisible(true);
            entity.setBaby();
            Location location = entity.getLocation();
            location.setPitch(0.0f);
            entity.teleport(location);
            entity.getEquipment().setHelmet(SUHItems.ORE_TITANIUM.getItemStack());
            Objects.requireNonNull(entity.getAttribute(Attribute.SCALE)).setBaseValue(0.5);
        }

        @Override
        protected void onThisEntityDamaged(Zombie entity, EntityDamageEvent event) {
            event.setCancelled(true);
        }

        @Override
        protected void onThisEntityDamagedByPlayer(Zombie entity, Player player, EntityDamageByEntityEvent event) {
            if (player.getInventory().getItemInMainHand().getType() == Material.DIAMOND_PICKAXE) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }),
    MISIONATTRIL(new FStandEntity("misionattril"){

        @Override
        protected void initViewStand(ArmorStand entity) {
            entity.setCustomName("Mision Attr");
            entity.setCustomNameVisible(true);
            entity.setGravity(false);
            entity.setBasePlate(false);
            entity.setArms(false);
            entity.setVisible(false);
            entity.setInvulnerable(true);
            entity.getAttribute(Attribute.SCALE).setBaseValue(1.6);
            entity.getEquipment().setHelmet(SUHItems.ATTRILMISSIONS.getItemStack());
        }

        @Override
        protected void onRightClickAtEntityEvent(Player player, ArmorStand entity, PlayerInteractAtEntityEvent event) {
            player.sendMessage("dado");
        }
    }),
    PORTAL(new FStandEntity("portal"){

        @Override
        protected void initViewStand(ArmorStand entity) {
            ItemStack stack = new ItemStack(Material.STICK);
            stack.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"portal"));
            entity.getEquipment().setHelmet(stack);
        }
    }),
    BLOOD_BAT((FEntity<? extends Entity>)new FLivingEntities<Bat>(Bat.class, "blood_bat"){

        @Override
        protected void initViewPeaceful(Bat entity) {
            entity.getEquipment().setHelmet(new ItemStack(Material.STICK));
        }

        @Override
        protected void thisEntityDrops(List<ItemStack> drops) {
            drops.clear();
            drops.add(SUHItems.BOLSA_SANGRE.getItemStack());
        }

        @Override
        protected void onThisEntityDieByPlayer(Bat entity, Player player) {
            ((TNTPrimed)entity.getWorld().spawn(entity.getLocation(), TNTPrimed.class)).setFuseTicks(0);
        }
    });

    private final FEntity<? extends Entity> fEntity;

    private SUHMobs(FEntity<? extends Entity> fEntity) {
        this.fEntity = fEntity;
    }

    public FEntity<? extends Entity> getfEntity() {
        return this.fEntity;
    }

    public void saveData() {
        FLivingEntities fMonster;
        FEntity<? extends Entity> fEntity = this.fEntity;
        if (fEntity instanceof FLivingEntities) {
            fMonster = (FLivingEntities)fEntity;
            fMonster.saveProb();
        }
        if ((fEntity = this.fEntity) instanceof FMonster) {
            fMonster = (FMonster)fEntity;
            ((FMonster)fMonster).saveData();
        }
    }

    public void loadData() {
        FLivingEntities fMonster;
        FEntity<? extends Entity> fEntity = this.fEntity;
        if (fEntity instanceof FLivingEntities) {
            fMonster = (FLivingEntities)fEntity;
            fMonster.loadProb();
        }
        if ((fEntity = this.fEntity) instanceof FMonster) {
            fMonster = (FMonster)fEntity;
            ((FMonster)fMonster).loadData();
        }
    }
}

