/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.fixfis.InitServer;
import me.fixfis.sUHCore.config.SUHGenericConfig;
import me.fixfis.sUHCore.events.SUHEvents;
import me.fixfis.sUHCore.items.SUHItems;
import me.fixfis.sUHCore.items.modItems.CrearItem;
import me.fixfis.sUHCore.mobs.SUHMobs;
import me.fixfis.sUHCore.muertes.Muertos;
import me.fixfis.sUHCore.muertes.Revivir;
import me.fixfis.sUHCore.sever_client.ClientUtils;
import me.fixfis.sUHCore.stuff.FCOMMANDS;
import me.fixfis.sUHCore.stuff.FLISTENER;
import me.fixfis.sUHCore.stuff.FTABCOMPLETER;
import me.fixfis.sUHCore.utils.config.FFileManager;
import me.fixfis.sUHCore.utils.logger.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.JSONObject;

public final class SUHCore
extends JavaPlugin {
    private final int idPlugin = 15;
    public static SUHCore instance;
    public static FFileManager fileManager;
    private InitServer initServer;
    public static JSONObject FILErevividos;
    public static JSONObject FILEmuertes;
    public static JSONObject FILEcraftings;
    public static JSONObject FILEmobs;
    public static JSONObject FILEevents;
    public static JSONObject FILEgenericconfig;
    private final List<UUID> playersInRain = new ArrayList<UUID>();

    public void onEnable() {
        fileManager = new FFileManager(String.valueOf(this.getDataFolder()) + "/");
        instance = this;
        this.initServer = new InitServer(15, this, "suhcore", true);
        if (this.initServer.getEstadoDeLicencia()) {
            FILEcraftings = fileManager.load(FFileManager.FILE.CRAFTING);
            FILEmobs = fileManager.load(FFileManager.FILE.MOBSFILE);
            FILEevents = fileManager.load(FFileManager.FILE.EVENTS_CONFIG);
            FILEgenericconfig = fileManager.load(FFileManager.FILE.GENERIC_CONFIG);
            FILEmuertes = fileManager.load(FFileManager.FILE.MUERTES_USERS);
            FILErevividos = fileManager.load(FFileManager.FILE.REVIVIDOS_USERS);
            this.runeable();
            this.initCommands();
            this.initSUHCore();
            FLogger.debugging("Plugin enabled!");
        }
    }

    public void onDisable() {
        if (this.initServer.getEstadoDeLicencia()) {
            this.disableSUHCore();
            fileManager.save(FILErevividos, FFileManager.FILE.REVIVIDOS_USERS);
            fileManager.save(FILEmuertes, FFileManager.FILE.MUERTES_USERS);
            fileManager.save(FILEcraftings, FFileManager.FILE.CRAFTING);
            fileManager.save(FILEmobs, FFileManager.FILE.MOBSFILE);
            fileManager.save(FILEevents, FFileManager.FILE.EVENTS_CONFIG);
            fileManager.save(FILEgenericconfig, FFileManager.FILE.GENERIC_CONFIG);
            FLogger.debugging("Plugin disabled!");
            CrearItem.itemStackHashMap.forEach((key, value) -> {
                if (Bukkit.removeRecipe((NamespacedKey)new NamespacedKey((Plugin)this, key))) {
                    FLogger.info("Receta " + key + " eliminada!");
                }
            });
        }
    }

    void initCommands() {
        ClientUtils cliente = new ClientUtils();
        this.getCommand("suhcore").setExecutor((CommandExecutor)new FCOMMANDS());
        this.getCommand("suhf66").setExecutor((CommandExecutor)cliente);
        this.getCommand("suhcore").setTabCompleter((TabCompleter)new FTABCOMPLETER());
        this.getServer().getPluginManager().registerEvents((Listener)new FLISTENER(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)cliente, (Plugin)this);
    }

    void initSUHCore() {
        SUHItems.values();
        SUHMobs.values();
        SUHMobs.values();
        Muertos.load();
        Revivir.load();
        for (SUHEvents sUHEvents : SUHEvents.values()) {
            sUHEvents.getCrearEvento().load();
        }
        for (Enum enum_ : SUHGenericConfig.values()) {
            ((SUHGenericConfig)enum_).getConfig().load();
        }
    }

    void disableSUHCore() {
        for (SUHEvents sUHEvents : SUHEvents.values()) {
            sUHEvents.getCrearEvento().save();
        }
        for (Enum enum_ : SUHGenericConfig.values()) {
            ((SUHGenericConfig)enum_).getConfig().save();
        }
        for (Enum enum_ : SUHMobs.values()) {
            ((SUHMobs)enum_).saveData();
        }
        for (Enum enum_ : SUHMobs.values()) {
            ((SUHMobs)enum_).saveData();
        }
        Muertos.save();
        Revivir.save();
    }

    void runeable() {
        BukkitRunnable runnable = new BukkitRunnable(this){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player == null) continue;
                    for (int i = 0; i < CrearItem.artifacts.size(); ++i) {
                        if (!CrearItem.artifacts.get(i).hasPlayerThisItemInHotbar(player)) continue;
                        CrearItem.artifacts.get(i).scheduleThatDoesThisItem(player);
                    }
                }
            }
        };
        runnable.runTaskTimer((Plugin)this, 0L, 200L);
        new BukkitRunnable(){

            public void run() {
                Bukkit.getOnlinePlayers().forEach(SUHCore.this::onAcidRain);
            }
        }.runTaskTimer((Plugin)this, 0L, 10L);
    }

    public void onAcidRain(final Player player) {
        if (SUHEvents.ACID_RAIN.isEnabled()) {
            if (this.playersInRain.contains(player.getUniqueId())) {
                return;
            }
            if (player.isInRain() && !player.isDead() && player.getGameMode() == GameMode.SURVIVAL) {
                this.playersInRain.add(player.getUniqueId());
                new BukkitRunnable(){

                    public void run() {
                        if (!player.isOnline() || player.isDead() || player.getGameMode() != GameMode.SURVIVAL || !player.isInRain() || !SUHEvents.ACID_RAIN.isEnabled() || SUHItems.UMBRELLA.isThisItem(player.getInventory().getItemInMainHand()) || SUHItems.UMBRELLA.isThisItem(player.getInventory().getItemInOffHand()) || SUHItems.UMBRELLA_HAT.isThisItem(player.getInventory().getHelmet())) {
                            SUHCore.this.playersInRain.remove(player.getUniqueId());
                            this.cancel();
                            return;
                        }
                        player.damage(Double.parseDouble(SUHGenericConfig.ACIDRAINDAMAGE.getValue().toString()));
                        player.sendHurtAnimation(1.0f);
                    }
                }.runTaskTimer((Plugin)instance, 0L, 20L);
            }
        }
    }

    public FFileManager getFileManager() {
        return fileManager;
    }
}

