/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs.modMobs;

import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.mobs.modMobs.EntityAttributes;
import org.json.JSONObject;

public class MobAttributes {
    private EntityAttributes attributes;
    private String keyName;
    private double spawn_prob;
    private double health;
    private double attack_damage;
    private double armor;
    private double scale;
    private double follow_range;
    private double speed;
    private double jump;
    private double knockback_resistance;
    private double attack_knockback;
    private Boolean powered;
    private Integer ticks_to_explode;
    private Integer explosion_radius;

    public MobAttributes(String keyName, EntityAttributes attributes) {
        this.keyName = keyName;
        this.attributes = attributes;
        this.load();
    }

    public void load() {
        JSONObject json = SUHCore.FILEmobs;
        if (json.has(this.keyName)) {
            JSONObject attr = json.getJSONObject(this.keyName);
            this.spawn_prob = attr.getDouble("spawn_prob");
            this.health = attr.getDouble("health");
            this.attack_damage = attr.getDouble("attack_damage");
            this.armor = attr.getDouble("armor");
            this.scale = attr.getDouble("scale");
            this.follow_range = attr.getDouble("follow_range");
            this.speed = attr.getDouble("speed");
            this.jump = attr.getDouble("jump");
            this.knockback_resistance = attr.getDouble("knockback_resistance");
            this.attack_knockback = attr.getDouble("attack_knockback");
            if (attr.has("powered")) {
                this.powered = attr.getBoolean("powered");
                this.ticks_to_explode = attr.getInt("ticks_to_explode");
                this.explosion_radius = attr.getInt("explosion_radius");
            }
        } else {
            this.spawn_prob = this.attributes.getJson().getDouble("spawn_prob");
            this.health = this.attributes.getJson().getDouble("health");
            this.attack_damage = this.attributes.getJson().getDouble("attack_damage");
            this.armor = this.attributes.getJson().getDouble("armor");
            this.scale = this.attributes.getJson().getDouble("scale");
            this.follow_range = this.attributes.getJson().getDouble("follow_range");
            this.speed = this.attributes.getJson().getDouble("speed");
            this.jump = this.attributes.getJson().getDouble("jump");
            this.knockback_resistance = this.attributes.getJson().getDouble("knockback_resistance");
            this.attack_knockback = this.attributes.getJson().getDouble("attack_knockback");
            if (this.attributes.getJson().has("powered")) {
                this.powered = this.attributes.getJson().getBoolean("powered");
                this.ticks_to_explode = this.attributes.getJson().getInt("ticks_to_explode");
                this.explosion_radius = this.attributes.getJson().getInt("explosion_radius");
            }
        }
    }

    public void save() {
        JSONObject attr = new JSONObject();
        attr.put("spawn_prob", this.spawn_prob);
        attr.put("health", this.health);
        attr.put("attack_damage", this.attack_damage);
        attr.put("armor", this.armor);
        attr.put("scale", this.scale);
        attr.put("follow_range", this.follow_range);
        attr.put("speed", this.speed);
        attr.put("jump", this.jump);
        attr.put("knockback_resistance", this.knockback_resistance);
        attr.put("attack_knockback", this.attack_knockback);
        if (this.powered != null) {
            attr.put("powered", this.powered);
            attr.put("ticks_to_explode", this.ticks_to_explode);
            attr.put("explosion_radius", this.explosion_radius);
        }
        SUHCore.FILEmobs.put(this.keyName, attr);
    }

    public String getKeyName() {
        return this.keyName;
    }

    public double getSpawn_prob() {
        return this.spawn_prob;
    }

    public double getHealth() {
        return this.health;
    }

    public double getAttack_damage() {
        return this.attack_damage;
    }

    public double getArmor() {
        return this.armor;
    }

    public double getScale() {
        return this.scale;
    }

    public double getFollow_range() {
        return this.follow_range;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getJump() {
        return this.jump;
    }

    public double getKnockback_resistance() {
        return this.knockback_resistance;
    }

    public double getAttack_knockback() {
        return this.attack_knockback;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public int getTicks_to_explode() {
        return this.ticks_to_explode;
    }

    public Integer getExplosion_radius() {
        return this.explosion_radius;
    }

    public void setSpawn_prob(double spawn_prob) {
        this.spawn_prob = spawn_prob;
    }
}

