/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.items;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Equippable;
import io.papermc.paper.datacomponent.item.Unbreakable;
import java.util.ArrayList;
import java.util.Objects;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.items.modItems.CrearItem;
import me.fixfis.sUHCore.items.modItems.ItemsUtils;
import me.fixfis.sUHCore.sever_client.ClientUtils;
import me.fixfis.sUHCore.utils.Texto;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.JSONObject;

public enum SUHItems {
    ORE_TITANIUM(new CrearItem(Material.STICK, "ore_titanium"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("Titanium Ore");
        }

        @Override
        protected void applyDataComponentModifications(ItemStack item, NamespacedKey key) {
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"ores/titanium"));
        }
    }),
    TOTEM_TOTEM_PIGLIN(new CrearItem(Material.TOTEM_OF_UNDYING, "totem_piglin"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setCustomModelData(Integer.valueOf(2));
        }

        @Override
        protected void createRecipe(ShapedRecipe recipe) {
            recipe.shape(new String[]{"k k", " k ", "k k"});
            recipe.setIngredient('k', Material.GOLD_NUGGET);
        }
    }),
    ADMIN_BLAZA_ADMIN(new CrearItem(Material.BLAZE_ROD, "blaze_admin"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName(Texto.aColor("Blaze debug (Solo Admins)"));
        }

        @Override
        protected void onRightClickAtAirEvent(Player player, ItemStack currentItem, PlayerInteractEvent event) {
            if (player.getInventory().getItemInOffHand().getType() != Material.AIR) {
                ItemsUtils.getPersitantData(player.getInventory().getItemInOffHand()).forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
            }
        }

        @Override
        protected void onPlayerDamageWithThisItem(final Player player, final Monster monster, EntityDamageByEntityEvent event) {
            if (!monster.isDead()) {
                final Bee bee = (Bee)player.getWorld().spawnEntity(player.getLocation(), EntityType.BEE);
                bee.setTarget((LivingEntity)monster);
                bee.setAggressive(true);
                new BukkitRunnable(this){
                    int t = 0;

                    public void run() {
                        if (this.t == 10 || monster.isDead() || !player.isConnected()) {
                            bee.remove();
                            this.cancel();
                        }
                        ++this.t;
                    }
                }.runTaskTimer((Plugin)SUHCore.instance, 0L, 10L);
            }
        }

        @Override
        protected void onRightClickAtEntityEvent(Player player, Entity entity, ItemStack currentItem, PlayerInteractEntityEvent event) {
            if (entity instanceof Monster) {
                Monster monster = (Monster)entity;
                if (event.getHand() == EquipmentSlot.HAND) {
                    JSONObject attr = new JSONObject();
                    attr.put("spawn_prob", 0);
                    attr.put("health", Objects.requireNonNull(monster.getAttribute(Attribute.MAX_HEALTH)).getValue());
                    attr.put("attack_damage", Objects.requireNonNull(monster.getAttribute(Attribute.ATTACK_DAMAGE)).getValue());
                    attr.put("armor", Objects.requireNonNull(monster.getAttribute(Attribute.ARMOR)).getValue());
                    attr.put("scale", Objects.requireNonNull(monster.getAttribute(Attribute.SCALE)).getValue());
                    attr.put("follow_range", Objects.requireNonNull(monster.getAttribute(Attribute.FOLLOW_RANGE)).getValue());
                    attr.put("speed", Objects.requireNonNull(monster.getAttribute(Attribute.MOVEMENT_SPEED)).getValue());
                    attr.put("jump", Objects.requireNonNull(monster.getAttribute(Attribute.JUMP_STRENGTH)).getValue());
                    attr.put("knockback_resistance", Objects.requireNonNull(monster.getAttribute(Attribute.KNOCKBACK_RESISTANCE)).getValue());
                    attr.put("attack_knockback", Objects.requireNonNull(monster.getAttribute(Attribute.ATTACK_KNOCKBACK)).getValue());
                    if (monster instanceof Creeper) {
                        Creeper creeper = (Creeper)monster;
                        attr.put("powered", creeper.isPowered());
                        attr.put("ticks_to_explode", creeper.getFuseTicks());
                    }
                    event.getPlayer().sendMessage(attr.toString(4));
                }
            }
        }
    }),
    ADMIN_FLASHBANG(new CrearItem(Material.FEATHER, "flashitauwu"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("CHII, TE VA A FALSHIAR, chi");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("chhii");
            lore.add("chick derecho flash");
            lore.add("chick izquiero pa \u00f1o");
            lore.add("uwu");
            meta.setLore(lore.stream().toList());
        }

        @Override
        protected void applyDataComponentModifications(ItemStack item, NamespacedKey key) {
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"admin/flash"));
        }

        @Override
        protected void onRightClickAtAirEvent(Player player, ItemStack currentItem, PlayerInteractEvent event) {
            ClientUtils.sendDataToClient(player, "flashed", 1);
        }

        @Override
        protected void onLeftClickAtAirEvent(Player player, ItemStack currentItem, PlayerInteractEvent event) {
            ClientUtils.sendDataToClient(player, "flashed", 0);
        }
    }),
    ADMIN_WEATHER_STAFF(new CrearItem(Material.BLAZE_ROD, "clima_staff"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
        }

        @Override
        protected void onRightClickAtAirEvent(Player player, ItemStack currentItem, PlayerInteractEvent event) {
            ClientUtils.sendDataToClient(player, "isAcidRain_1");
        }

        @Override
        protected void onLeftClickAtAirEvent(Player player, ItemStack currentItem, PlayerInteractEvent event) {
            ClientUtils.sendDataToClient(player, "isAcidRain_0");
        }
    }),
    UTIL_EXPANSION_SLOT(new CrearItem(Material.FEATHER, "expansion_slot"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("expansion Slot");
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        }
    }),
    ARTIFAC_REACH(new CrearItem(Material.FEATHER, "reach_artifac"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("REACHER");
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        }

        @Override
        protected boolean isArtifact() {
            return true;
        }

        @Override
        public void scheduleThatDoesThisItem(Player player) {
            super.scheduleThatDoesThisItem(player);
        }
    }),
    ARTIFAC_BOTAS_HERMES(new CrearItem(Material.FEATHER, "botas_hermes_artifac"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("HERMES");
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        }

        @Override
        protected boolean isArtifact() {
            return true;
        }

        @Override
        public void scheduleThatDoesThisItem(Player player) {
            this.modificarAtributoAlJugador(player, Attribute.MOVEMENT_SPEED, 0.1);
        }
    }),
    BOLSA_SANGRE(new CrearItem(Material.STICK, "bolsa_sangre"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("Bolsa de Sangre");
        }

        @Override
        protected void onRightClickAtAirEvent(Player player, ItemStack currentItem, PlayerInteractEvent event) {
            ItemsUtils.hasBeenUsedForMission(currentItem, player);
            player.sendMessage("added");
        }

        @Override
        protected void onLeftClickAtAirEvent(Player player, ItemStack currentItem, PlayerInteractEvent event) {
            ItemsUtils.hasNotBeenUsedForMission(currentItem);
            player.sendMessage("removed");
        }
    }),
    TITANIUM_HELMET(new CrearItem(Material.STICK, "titanium_helmet"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("ARMOR TEST");
        }

        @Override
        protected void applyDataComponentModifications(ItemStack item, NamespacedKey key) {
            item.setData(DataComponentTypes.EQUIPPABLE, (Object)((Equippable)Equippable.equippable((EquipmentSlot)EquipmentSlot.HEAD).assetId(Key.key((String)"suhcore", (String)"tita")).build()));
            item.setData(DataComponentTypes.UNBREAKABLE, (Object)Unbreakable.unbreakable((boolean)false));
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"bat_blood"));
        }

        @Override
        protected void createRecipe(ShapedRecipe recipe) {
            recipe.shape(new String[]{"ttt", "t t", "   "});
            recipe.setIngredient('t', ORE_TITANIUM.getItemStack());
        }
    }),
    TITANIUM_CHEST(new CrearItem(Material.STICK, "titanium_chest"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("ARMOR TEST");
        }

        @Override
        protected void applyDataComponentModifications(ItemStack item, NamespacedKey key) {
            item.setData(DataComponentTypes.EQUIPPABLE, (Object)((Equippable)Equippable.equippable((EquipmentSlot)EquipmentSlot.CHEST).assetId(Key.key((String)"suhcore", (String)"tita")).build()));
            item.setData(DataComponentTypes.UNBREAKABLE, (Object)Unbreakable.unbreakable((boolean)false));
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"bat_blood"));
        }

        @Override
        protected void createRecipe(ShapedRecipe recipe) {
            recipe.shape(new String[]{"t t", "ttt", "ttt"});
            recipe.setIngredient('t', ORE_TITANIUM.getItemStack());
        }
    }),
    TITANIUM_LEGGING(new CrearItem(Material.STICK, "titanium_leggins"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("ARMOR TEST");
        }

        @Override
        protected void applyDataComponentModifications(ItemStack item, NamespacedKey key) {
            item.setData(DataComponentTypes.EQUIPPABLE, (Object)((Equippable)Equippable.equippable((EquipmentSlot)EquipmentSlot.LEGS).assetId(Key.key((String)"suhcore", (String)"tita")).build()));
            item.setData(DataComponentTypes.UNBREAKABLE, (Object)Unbreakable.unbreakable((boolean)false));
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"bat_blood"));
        }

        @Override
        protected void createRecipe(ShapedRecipe recipe) {
            recipe.shape(new String[]{"ttt", "t t", "t t"});
            recipe.setIngredient('t', ORE_TITANIUM.getItemStack());
        }
    }),
    TITANIUM_BOOTS(new CrearItem(Material.STICK, "titanium_boots"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("ARMOR TEST");
        }

        @Override
        protected void applyDataComponentModifications(ItemStack item, NamespacedKey key) {
            item.setData(DataComponentTypes.EQUIPPABLE, (Object)((Equippable)Equippable.equippable((EquipmentSlot)EquipmentSlot.FEET).assetId(Key.key((String)"suhcore", (String)"tita")).build()));
            item.setData(DataComponentTypes.UNBREAKABLE, (Object)Unbreakable.unbreakable((boolean)false));
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"bat_blood"));
        }

        @Override
        protected void createRecipe(ShapedRecipe recipe) {
            recipe.shape(new String[]{"   ", "t t", "t t"});
            recipe.setIngredient('t', ORE_TITANIUM.getItemStack());
        }
    }),
    SPECTRE_HELMET(new CrearItem(Material.STICK, "SPECTRE_helmet"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("ARMOR TEST");
        }

        @Override
        protected void applyDataComponentModifications(ItemStack item, NamespacedKey key) {
            item.setData(DataComponentTypes.EQUIPPABLE, (Object)((Equippable)Equippable.equippable((EquipmentSlot)EquipmentSlot.HEAD).assetId(Key.key((String)"suhcore", (String)"spectre")).build()));
            item.setData(DataComponentTypes.UNBREAKABLE, (Object)Unbreakable.unbreakable((boolean)false));
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"bat_blood"));
        }

        @Override
        protected void createRecipe(ShapedRecipe recipe) {
            recipe.shape(new String[]{"ttt", "t t", "   "});
            recipe.setIngredient('t', ORE_TITANIUM.getItemStack());
        }
    }),
    SPECTRE_CHEST(new CrearItem(Material.STICK, "SPECTRE_chest"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("ARMOR TEST");
        }

        @Override
        protected void applyDataComponentModifications(ItemStack item, NamespacedKey key) {
            item.setData(DataComponentTypes.EQUIPPABLE, (Object)((Equippable)Equippable.equippable((EquipmentSlot)EquipmentSlot.CHEST).assetId(Key.key((String)"suhcore", (String)"spectre")).build()));
            item.setData(DataComponentTypes.UNBREAKABLE, (Object)Unbreakable.unbreakable((boolean)false));
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"bat_blood"));
        }

        @Override
        protected void createRecipe(ShapedRecipe recipe) {
            recipe.shape(new String[]{"t t", "ttt", "ttt"});
            recipe.setIngredient('t', ORE_TITANIUM.getItemStack());
        }
    }),
    SPECTRE_LEGGING(new CrearItem(Material.STICK, "SPECTRE_leggins"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("ARMOR TEST");
        }

        @Override
        protected void applyDataComponentModifications(ItemStack item, NamespacedKey key) {
            item.setData(DataComponentTypes.EQUIPPABLE, (Object)((Equippable)Equippable.equippable((EquipmentSlot)EquipmentSlot.LEGS).assetId(Key.key((String)"suhcore", (String)"spectre")).build()));
            item.setData(DataComponentTypes.UNBREAKABLE, (Object)Unbreakable.unbreakable((boolean)false));
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"bat_blood"));
        }

        @Override
        protected void createRecipe(ShapedRecipe recipe) {
            recipe.shape(new String[]{"ttt", "t t", "t t"});
            recipe.setIngredient('t', ORE_TITANIUM.getItemStack());
        }
    }),
    SPECTRE_BOOTS(new CrearItem(Material.STICK, "SPECTRE_boots"){

        @Override
        protected void howsThisItemWouldLookLike(ItemMeta meta, NamespacedKey key) {
            meta.setDisplayName("ARMOR TEST");
        }

        @Override
        protected void applyDataComponentModifications(ItemStack item, NamespacedKey key) {
            item.setData(DataComponentTypes.EQUIPPABLE, (Object)((Equippable)Equippable.equippable((EquipmentSlot)EquipmentSlot.FEET).assetId(Key.key((String)"suhcore", (String)"spectre")).build()));
            item.setData(DataComponentTypes.UNBREAKABLE, (Object)Unbreakable.unbreakable((boolean)false));
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"bat_blood"));
        }

        @Override
        protected void createRecipe(ShapedRecipe recipe) {
            recipe.shape(new String[]{"   ", "t t", "t t"});
            recipe.setIngredient('t', ORE_TITANIUM.getItemStack());
        }
    });

    private final CrearItem crearItem;
    private final ItemStack itemStack;
    private final String keyName;

    private SUHItems(CrearItem crearItem) {
        this.crearItem = crearItem;
        this.itemStack = crearItem.getItem();
        this.keyName = crearItem.getKey().getKey();
    }

    public String getKeyName() {
        return this.keyName;
    }

    public CrearItem getCrearItem() {
        return this.crearItem;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean isThisItem(ItemStack itemStack) {
        return this.crearItem.isThisItem(itemStack);
    }

    public boolean hasPlayerThisItem(Player player, int discount) {
        return this.crearItem.hasPlayerThisItem(player, discount);
    }

    public boolean hasPlayerThisItemInHotbar(Player player) {
        return this.crearItem.hasPlayerThisItemInHotbar(player);
    }
}

